<?php
/* --------------------------------------------------------------
   ParcelServices.php 2020-02-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\ParcelService\Model;

use ArrayIterator;
use Gambio\Admin\ParcelService\Interfaces\ParcelService;
use Gambio\Admin\ParcelService\Interfaces\ParcelServices as ParcelServicesInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class ParcelServices
 * @package Gambio\Admin\ParcelService\Model
 */
class ParcelServices implements ParcelServicesInterface
{
    /**
     * @var ParcelService[]
     */
    private $parcelServices;
    
    
    /**
     * ParcelServices constructor.
     *
     * @param ParcelService[] $parcelServices
     */
    private function __construct(array $parcelServices)
    {
        $this->parcelServices = $parcelServices;
    }
    
    
    /**
     * @param ParcelService ...$parcelServices
     *
     * @return ParcelServices
     */
    public static function create(ParcelService ...$parcelServices): ParcelServices
    {
        return new self($parcelServices);
    }
    
    
    /**
     * @param ParcelService[] $parcelServices
     *
     * @return ParcelServices
     */
    public static function createWithReferences(array $parcelServices): ParcelServices
    {
        Assert::allIsInstanceOf($parcelServices,
                                ParcelService::class,
                                'All items in provided list need to implement "' . ParcelService::class
                                . '".');
        
        return new self($parcelServices);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new ArrayIterator($this->parcelServices);
    }
    
    
    /**
     * @inheritDoc
     */
    public function items(): array
    {
        return $this->parcelServices;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return $this->items();
    }
}